import { Component, OnInit } from '@angular/core';
import { ActiveState } from '../../core/activestate/activestate.service'
import { MainContentService } from '../../core/maincontent/maincontent.service'
import { Product } from '../../core/maincontent/product'

@Component({
  selector: 'app-epayment-home',
  templateUrl: './epayment-home.component.html',
  styleUrls: ['./epayment-home.component.css']
})
export class EpaymentHomeComponent implements OnInit {
  maincontentService: MainContentService
  product: Product

  constructor(public activeState: ActiveState,
          private mcService: MainContentService) {
    this.maincontentService = mcService
  }

  ngOnInit() {
    this.maincontentService.getProduct('epayments').subscribe(this.contentUpdate.bind(this))
  }

  contentUpdate(prod: Product) {
    this.product = prod
  }

}
